/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet;

import com.ibm.hwmca.fw.tasklet.impl.RawRequest;
import com.ibm.hwmca.fw.tasklet.impl.TaskletRequestConstants;
import com.ibm.hwmca.fw.tasklet.impl.XFrameUtils;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public class TaskletRequest
extends RawRequest
implements TaskletRequestConstants {
    private static final String TRACE_MASKT = "XTSKOTRT";
    private static final String TRACE_MASKF = "XTSKOTRF";
    private static final String TRACE_MASKD = "XTSKOTRD";
    protected int mode = 0;
    private Object context = null;
    private Object source = null;
    private boolean isInitialRequest = false;

    public TaskletRequest(Object source) {
        Trace.trace(TRACE_MASKF, "[TaskletRequest] <init>");
        this.source = source;
    }

    public TaskletRequest() {
        this(null);
    }

    public final boolean isInitialRequest() {
        return this.isInitialRequest;
    }

    public final void setInitialRequest(boolean value) {
        this.isInitialRequest = value;
    }

    public final Object getSource() {
        return this.source;
    }

    public final void setSource(Object source) {
        this.source = source;
    }

    public final void setNormal() {
        Trace.trace(TRACE_MASKF, "[TaskletRequest] setNormal()");
        this.setMode(0);
    }

    public boolean isNormal() {
        return this.mode == 0;
    }

    protected void setMode(int mode) {
        this.mode = mode;
    }

    public void setContext(Map context) {
        if (context != null && !(context instanceof Serializable)) {
            throw new IllegalArgumentException("Map parmameter must implement serializable");
        }
        this.context = context;
    }

    public Map getContext() {
        if (this.context != null) {
            return (Map)this.context;
        }
        return Collections.EMPTY_MAP;
    }

    public String toString() {
        return "TaskletRequest[...]";
    }

    protected static String modeToString(int theMode) {
        switch (theMode) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Cancel";
            }
            case 2: {
                return "Dispose";
            }
            case 4: {
                return "Control";
            }
        }
        return "*Unknown*";
    }

    public void captureDebugInformation(StringBuffer sb) {
        sb.append("\tisInitialRequest = ").append(this.isInitialRequest).append("\n");
        sb.append("\tsource = ").append(this.source).append("\n");
        sb.append("\tmode = ").append(TaskletRequest.modeToString(this.mode)).append("\n");
        super.captureDebugInformation(sb);
    }

    public void debugToTrace() {
        Trace.trace("XTSK---F", XFrameUtils.getTraceArgSB().append("\tisInitialRequest = ").append(this.isInitialRequest).toString());
        Trace.trace("XTSK---F", XFrameUtils.getTraceArgSB().append("\tsource = ").append(this.source).toString());
        Trace.trace("XTSK---F", XFrameUtils.getTraceArgSB().append("\tmode = ").append(TaskletRequest.modeToString(this.mode)).toString());
        super.debugToTrace();
    }
}

